* This program practice FIXED EFFECTS and 1ST DIFFERENCES using a data set that was constrcuted


# delimit;
clear ;
set more off ;

set matsize 11000 ;

capture log close ;


/*
GLOBALS
INSERET THE LOCATION/FOLDER ON YOUR COMPUTER
*/

global FOLDER "/Users/yonarubinstein/Dropbox/TEACHING/LSE/MG4A4 EMPIRICAL RESEARCH STRATEGY FOR MANAGERIAL ECONOMICS/POST/DATA AND PROGRAMS/" ;

cd "$LOG/" ;


log using "$FOLDER/MG4A4 PRACTICE FIXED EFFECTS WITH ARTIFICIAL DATA.log", replace ;



/* ********************************************************************************************************* */
/* ******************************************** UPLOAD THE FILE ******************************************** */
/* ********************************************************************************************************* */


use "$FOLDER/MG4A4 ARTIFICIAL DATA FOR FIXED EFFECTS.dta", clear ;


/*
(1) DESCRIBE
*/

des ;

/*
(2) SUMMARIZE
*/

sum ;

sort Fi ;
by Fi: sum ;


sort Fi Fit ;
by Fi Fit: sum ;

/*
(3) GENERATE MEANS FOR EACH INDIVIDUAL
*/


egen Yim = mean(Yit), by(id); 
egen Fim = mean(Fit), by(id); 
egen Sim = mean(Si), by(id); 
egen EXPim  = mean(EXPit), by(id); 
egen EXP2im = mean(EXP2it), by(id); 
egen YEARim = mean(YEAR), by(id); 


gen _Yit = Yit - Yim ;
gen _Fit = Fit - Fim ;
gen _Sit = Si - Sim ;
gen _EXPit = EXPit - EXPim ;
gen _EXP2it = EXP2it - EXP2im ;
gen _YEAR   = YEAR - YEARim ; 




/*
(4) WAGE REGRESSION OLS
*/
reg Yit Fit YEAR Si EXPit EXP2it  ;
estimates store OLS1, title((CRUDE1));


/*
(5) DEVIATIONS FROM EACH ID MEANS
*/


reg _Yit _Fit _YEAR _Sit _EXPit _EXP2it  ;
estimates store OLS2, title((CRUDE1));


/*
(6) WAGE REGRESSION FIXED EFFECTS
*/
xtreg Yit Fit YEAR Si EXPit EXP2it, fe i(id)  ;
estimates store FE1, title((CRUDE1));


areg Yit Fit YEAR Si EXPit EXP2it, absorb(id)  ;
estimates store FE2, title((CRUDE2));



estout OLS1 OLS2 FE1 FE2 using "$FOLDER/MG4A4 PRACTICE FIXED EFFECTS WITH ARTITIFAL DATA.txt", 
replace keep 
(_cons Fit YEAR Si EXPit EXP2it _Fit _YEAR _EXP2it)
cells(b(star fmt(3)) se(par fmt (3)))
varlabels(_cons Constant)
stats(N r2 , fmt(0 3 0) labels(Observations R-square))
starlevels(* 0.10 ** 0.05 *** 0.01)
prehead("TABLE 2A" "REGRESSION COEFFICIENTS")
posthead("")
prefoot("")
postfoot(""
"Notes."
"TBA"
"Robust standard errors clustered statefip in parentheses."
"* Significant at 10%; ** significant at 5%; *** significant at 1%." ) ;


log close ;
